<?php
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile: admin_pmall.php,v $ - $Revision: 1.00 $');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header("  ");

function prefix_or($str)
{
        return $str == '' ? '' : ' or ';
}

function get_mass_pm_sql_condition($primary, $secondary)
{
        $String = '';

        if (is_array($primary))
        {
                $Doprimary = implode(',', $primary);
        }
        else if ($primary)
        {
                $Doprimary = intval($primary);
        }

        if ($Doprimary)
        {
                $String = 'usergroupid in (' . $Doprimary . ')';
        }

        if (is_array($secondary))
        {
                foreach ($secondary as $second)
                {
                        $String .= prefix_or($String) . 'find_in_set(\'' . intval($second) . '\', membergroupids)';
                }
        }
        else if ($secondary)
        {
                $String .= prefix_or($String) . 'find_in_set(\'' . intval($secondary) . '\', membergroupids)';
        }

        if ($String == '')
        {
                print_stop_message('mass_pm_fail');
        }

        return $String;
}

// ###################### Send PM ########################
if ($_REQUEST['do'] == '')
{
        $UserGroups = array();

        $usergroups = $db->query("select usergroupid, title FROM " . TABLE_PREFIX . "usergroup ORDER BY title");

        while ($usergroup = $db->fetch_array($usergroups))
        {
                $UserGroups[$usergroup['usergroupid']] = $usergroup['title'];
        }

        print_form_header('admin_pmall', 'mass_pm');
        print_table_header("  ");

        print_input_row($vbphrase['pm_process_amount'], 'pm_amount','100');

        print_select_row($vbphrase['mass_pm_primary'], 'pm_primary[]', $UserGroups, -1, false, 7, true);
        print_select_row($vbphrase['mass_pm_secondary'], 'pm_secondary[]', $UserGroups, -1, false, 7, true);

        print_input_row($vbphrase['mass_pm_title'],'pm_title');
        print_textarea_row($vbphrase['mass_pm_content'],'pm_content');

        print_submit_row('  ', 0);
        print_cp_footer();
        exit;
}

// ###################### Send Mass PM ########################
if ($_REQUEST['do'] == 'mass_pm')
{
        $vbulletin->input->clean_array_gpc('p', array(
                'pm_amount'        => TYPE_INT,
                'pm_primary'        => TYPE_ARRAY,
                'pm_secondary'        => TYPE_ARRAY,
                'pm_title'        => TYPE_STR,
                'pm_content'        => TYPE_STR,
        ));

        $vbulletin->input->clean_array_gpc('g', array(
                'counter'        => TYPE_INT,
                'amount'        => TYPE_INT,
                'title'                => TYPE_STR,
                'content'        => TYPE_STR,
                'primary'        => TYPE_STR,
                'secondary'        => TYPE_STR,
        ));

        $Title   = ($vbulletin->GPC['pm_title'])?   $vbulletin->GPC['pm_title']   : $vbulletin->GPC['title'];
        $Message = ($vbulletin->GPC['pm_content'])? $vbulletin->GPC['pm_content'] : $vbulletin->GPC['content'];

        if (trim($Title) == '' || trim($Message) == '')
        {
                print_stop_message('mass_pm_nodata');
        }

        if ($vbulletin->GPC['pm_title'])
        {
                $Prime  = $vbulletin->GPC['pm_primary'];
                $Secon  = $vbulletin->GPC['pm_secondary'];
                $Start  = 0;
                $Amount = iif($vbulletin->GPC['pm_amount'] > 10, $vbulletin->GPC['pm_amount'], 10);
                $Finish = $Amount + $Start;
        }
        else
        {
                $Prime  = explode(',', $vbulletin->GPC['primary']);
                $Secon  = explode(',', $vbulletin->GPC['secondary']);
                $Start  = $vbulletin->GPC['counter'];
                $Amount = $vbulletin->GPC['amount'];
                $Finish = $Amount + $Start;
        }

        $Redir = true;
        $Users = $db->query("select username from " . TABLE_PREFIX . "user where " . get_mass_pm_sql_condition($Prime, $Secon));
        while ($User = $db->fetch_array($Users))
        {
                $PMUser[] = $User['username'];
        }

        if (!is_array($PMUser))
        {
                print_stop_message('mass_pm_fail');
        }

        for ($u = $Start; $u < $Finish; $u++)
        {
                if ($PMUser[$u])
                {
                        $PMUsers[] = unhtmlspecialchars($PMUser[$u]);
                }
                else
                {
                        $Redir     = false;
                }
        }

        if (is_array($PMUsers))
        {
                $PMUsers = implode(';', $PMUsers);
                $BotPerm = array();
                $BotPerm['adminpermissions'] = 2;

                $PM_DM =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
                $PM_DM->set('fromuserid', $vbulletin->userinfo['userid']);
                $PM_DM->set('fromusername', $vbulletin->userinfo['username']);
                $PM_DM->set('title', $Title);
                $PM_DM->set('message', $Message);
                $PM_DM->set_recipients($PMUsers, $BotPerm);
                $PM_DM->set('dateline', TIMENOW);
                $PM_DM->save();
        }

        $Prime   = implode(',', $Prime);
        $Secon   = implode(',', $Secon);
        $Title   = urlencode($Title);
        $Message = urlencode($Message);

        if ($Redir)
        {
                echo "<script type='text/javascript'>
                <!--
                function move()
                {
                        window.location = 'admin_pmall.php?do=mass_pm&counter={$Finish}&amount={$Amount}&primary={$Prime}&secondary={$Secon}&title={$Title}&content={$Message}'
                }
                setTimeout('move()',2000)
                -->
                </script>
                <br />
                <a href='admin_pmall.php?do=mass_pm&counter={$Finish}&amount={$Amount}&primary={$Prime}&secondary={$Secon}&title={$Title}&content={$Message}'>{$vbphrase['mass_pm_batch']}</a>";
        }
        else
        {
                define('CP_REDIRECT', 'admin_pmall.php?');
                print_stop_message('mass_pm_complete');
        }
}

?>